'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"assets/assets/png/flutter-logo-dark.png": "86bcb4bc08d1539b4d3b25fb58c9f6c5",
"assets/assets/png/flutter-logo.png": "3b87320b0f7fffa16e05e4829fd92da3",
"assets/assets/png/flutter-logo-light.png": "d0515092173211776ceed19b39c2a041",
"assets/assets/svg/tab-location.svg": "8a15c1fd0fac416ba442dd2f1e3b6c83",
"assets/assets/svg/profile-circle-doctor.svg": "210794985f4ec0b6cc465e1e04c40664",
"assets/assets/svg/profile-square-location.svg": "78b2b21cd9ec844d65962f2177461129",
"assets/assets/svg/profile-square-doctor.svg": "6f3b2c62afa33098b24b06d009ca5e7a",
"assets/assets/svg/profile-circle-location.svg": "8af0f19419e6b7889ccecd2ba338757d",
"assets/assets/svg/bullet-point.svg": "0082fab4fdafdc7f590d78320a1fca75",
"assets/assets/svg/mybswlogo.svg": "56ee7113ae179cb3887cf46ad91773e8",
"assets/assets/svg/tab-doctor.svg": "e1e9c325fe66b7c2c76eb776e3220c89",
"assets/assets/icon/icon-128.png": "cfe99f24abe98381b5d73cf2c834128d",
"assets/assets/icon/icon-512.png": "5f122ab460ac729c7e6d58fb60b1fc57",
"assets/assets/icon/icon-256.png": "babc439521d7e6f3b8052bcf7f012b48",
"assets/assets/icon/icon-16.png": "f8bbe16e6a35a0b8dbbbd64e9756f500",
"assets/assets/icon/icon-64.png": "398eb4d121094e77503888b66cbb77fb",
"assets/assets/icon/icon-24.png": "81b45c1ad3eb89839055402990e47859",
"assets/assets/icon/icon-32.png": "51ed6bcafcf45becf422ce6d50e3eb33",
"assets/AssetManifest.json": "26e35b5f1d30968f310a5e14c43ed126",
"assets/fonts/MaterialIcons-Regular.otf": "6e45a712314143d27e69c942e7cbfab0",
"assets/AssetManifest.bin": "b9c3775017d3b0e759ff1479fe7f651e",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"assets/AssetManifest.bin.json": "65bcbb5dc885ece834cf68a03a402eb9",
"assets/NOTICES": "4b10e8b7e1e5a3fc8379e34eeb869ea7",
"assets/FontManifest.json": "5a32d4310a6f5d9a6b651e75ba0d7372",
"assets/packages/font_awesome_flutter/lib/fonts/fa-brands-400.ttf": "4769f3245a24c1fa9965f113ea85ec2a",
"assets/packages/font_awesome_flutter/lib/fonts/fa-regular-400.ttf": "3ca5dc7621921b901d513cc1ce23788c",
"assets/packages/font_awesome_flutter/lib/fonts/fa-solid-900.ttf": "f5642e7f1c568395dcead40a3ce903dd",
"assets/packages/wakelock_plus/assets/no_sleep.js": "7748a45cd593f33280669b29c2c8919a",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "d7d83bd9ee909f8a9b348f56ca7b68c6",
"icons/Icon-maskable-512.png": "aed07425813c69287e533ffa2224be36",
"icons/Icon-192.png": "73a140eaea2012aabb1a565d7a8ad6c7",
"icons/Icon-512.png": "aed07425813c69287e533ffa2224be36",
"icons/Icon-maskable-192.png": "73a140eaea2012aabb1a565d7a8ad6c7",
"flutter_bootstrap.js": "da35d91791d4cd0b1a477c24e55005cc",
"prior-ndx/prior-ndx-files.zip": "57c7adfdebf23f434caedfdffbe50120",
"main.dart.js": "94a2164c38a52b6c1c0085f577fc17eb",
"favicon.png": "59e330ac4944bbc31b5f1104953638cf",
"flutter.js": "83d881c1dbb6d6bcd6b42e274605b69c",
"version.json": "cda538b5cfa2903d1dc194304d585339",
"canvaskit/canvaskit.wasm": "7a3f4ae7d65fc1de6a6e7ddd3224bc93",
"canvaskit/skwasm.js.symbols": "e72c79950c8a8483d826a7f0560573a1",
"canvaskit/canvaskit.js.symbols": "bdcd3835edf8586b6d6edfce8749fb77",
"canvaskit/skwasm.wasm": "39dd80367a4e71582d234948adc521c0",
"canvaskit/canvaskit.js": "728b2d477d9b8c14593d4f9b82b484f3",
"canvaskit/chromium/canvaskit.wasm": "f504de372e31c8031018a9ec0a9ef5f0",
"canvaskit/chromium/canvaskit.js": "8191e843020c832c9cf8852a4b909d4c",
"canvaskit/chromium/canvaskit.js.symbols": "b61b5f4673c9698029fa0a746a9ad581",
"canvaskit/skwasm.js": "ea559890a088fe28b4ddf70e17e60052",
"index.html": "aee680cd4afdb2af91ae4314434efc05",
"/": "aee680cd4afdb2af91ae4314434efc05",
"manifest.json": "73882ff22745539dc756b6e3115657c4"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
