'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"favicon.png": "30058292afbb665572694164893ab43f",
"icons/Icon-maskable-512.png": "509dce4b1cf6a9859a322a2f0702b46a",
"icons/Icon-512.png": "509dce4b1cf6a9859a322a2f0702b46a",
"icons/Icon-192.png": "35fdc910a5fecca5bf1261e7a86e30a3",
"icons/Icon-maskable-192.png": "35fdc910a5fecca5bf1261e7a86e30a3",
"README.md": "7f7bff009e785058aa6b6017564bc426",
"manifest.json": "a001343bdfbd28b2d19da83a898b8151",
"prior-ndx/prior-ndx-files.zip": "57c7adfdebf23f434caedfdffbe50120",
"main.dart.js": "f7c7da3313028f1736ffa2560cee6e72",
"index.html": "16633a7a5a79340cfb9a4d42d2ad6661",
"/": "16633a7a5a79340cfb9a4d42d2ad6661",
"assets/fonts/MaterialIcons-Regular.otf": "09d4b90b73b8a7aa76abd1ef71c7fdcf",
"assets/NOTICES": "d01ac867863345659998628c18e777cc",
"assets/AssetManifest.bin.json": "42ef4385d6923844d05393d9e12d16e5",
"assets/packages/wakelock_plus/assets/no_sleep.js": "7748a45cd593f33280669b29c2c8919a",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "d7d83bd9ee909f8a9b348f56ca7b68c6",
"assets/packages/font_awesome_flutter/lib/fonts/fa-brands-400.ttf": "15d54d142da2f2d6f2e90ed1d55121af",
"assets/packages/font_awesome_flutter/lib/fonts/fa-solid-900.ttf": "15a570c9edb6511a980292454c640c98",
"assets/packages/font_awesome_flutter/lib/fonts/fa-regular-400.ttf": "262525e2081311609d1fdab966c82bfc",
"assets/FontManifest.json": "5a32d4310a6f5d9a6b651e75ba0d7372",
"assets/AssetManifest.json": "dba0e4872680f814f9bb53fd4b954e56",
"assets/svg/health-logo-light.svg": "04dbbc885976cf302f0f3d9d8b8c3629",
"assets/svg/health-logo-dark.svg": "de0e9e173a66e3d57e1640f22f37a8ff",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"assets/AssetManifest.bin": "b8be5a310cd0e1a7c8b5c6fae4eac300",
"assets/assets/png/flutter-logo-light.png": "d0515092173211776ceed19b39c2a041",
"assets/assets/png/flutter-logo-dark.png": "86bcb4bc08d1539b4d3b25fb58c9f6c5",
"assets/assets/png/health-logo-light.png": "6b65d9bf3f6fddf8550f9ed360492cf8",
"assets/assets/png/flutter-logo.png": "3b87320b0f7fffa16e05e4829fd92da3",
"assets/assets/png/health-logo-dark.png": "1f6e4f6ffe36b9891272a28df3bc71da",
"assets/assets/svg/tab-doctor.svg": "e1e9c325fe66b7c2c76eb776e3220c89",
"assets/assets/svg/tab-location.svg": "8a15c1fd0fac416ba442dd2f1e3b6c83",
"assets/assets/svg/profile-square-location.svg": "78b2b21cd9ec844d65962f2177461129",
"assets/assets/svg/profile-circle-doctor.svg": "210794985f4ec0b6cc465e1e04c40664",
"assets/assets/svg/mybswlogo.svg": "56ee7113ae179cb3887cf46ad91773e8",
"assets/assets/svg/profile-square-doctor.svg": "6f3b2c62afa33098b24b06d009ca5e7a",
"assets/assets/svg/health-logo-light.svg": "04dbbc885976cf302f0f3d9d8b8c3629",
"assets/assets/svg/health-logo-dark.svg": "de0e9e173a66e3d57e1640f22f37a8ff",
"assets/assets/svg/profile-circle-location.svg": "8af0f19419e6b7889ccecd2ba338757d",
"assets/assets/svg/bullet-point.svg": "0082fab4fdafdc7f590d78320a1fca75",
"assets/assets/icon/icon-32.png": "d7528497d74405587440984dfdd739ea",
"assets/assets/icon/icon-64.png": "5ddf100b54b195cc44bb4846201c7c7b",
"assets/assets/icon/icon-16.png": "08f6fb06ec47db8c560397c71bda8a00",
"assets/assets/icon/icon-24.png": "227bc096710fdd5101b15aa3cc3c2f1f",
"assets/assets/icon/icon-512.png": "de0ab082dde3247da067d8c620054503",
"assets/assets/icon/icon-256.png": "66f26077662f0ead38639fe0cc819975",
"assets/assets/icon/icon-128.png": "ee027a53ae58603ae416281104684851",
"canvaskit/chromium/canvaskit.wasm": "f504de372e31c8031018a9ec0a9ef5f0",
"canvaskit/chromium/canvaskit.js": "8191e843020c832c9cf8852a4b909d4c",
"canvaskit/chromium/canvaskit.js.symbols": "b61b5f4673c9698029fa0a746a9ad581",
"canvaskit/skwasm.wasm": "39dd80367a4e71582d234948adc521c0",
"canvaskit/canvaskit.wasm": "7a3f4ae7d65fc1de6a6e7ddd3224bc93",
"canvaskit/canvaskit.js.symbols": "bdcd3835edf8586b6d6edfce8749fb77",
"canvaskit/skwasm.js": "ea559890a088fe28b4ddf70e17e60052",
"canvaskit/canvaskit.js": "728b2d477d9b8c14593d4f9b82b484f3",
"canvaskit/skwasm.js.symbols": "e72c79950c8a8483d826a7f0560573a1",
"flutter.js": "83d881c1dbb6d6bcd6b42e274605b69c",
"version.json": "4297e9a2d1cef0d6497dfe1024b3faaa",
"flutter_bootstrap.js": "da35d91791d4cd0b1a477c24e55005cc"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
